### 44.2. 数据源指标

Spring Boot会为你应用中定义的支持的DataSource暴露以下指标：
- 最大连接数（datasource.xxx.max）
- 最小连接数（datasource.xxx.min）
- 活动连接数（datasource.xxx.active）
- 连接池的使用情况（datasource.xxx.usage）

所有的数据源指标共用`datasoure.`前缀。该前缀对每个数据源都非常合适：
- 如果是主数据源（唯一可用的数据源或存在的数据源中被@Primary标记的）前缀为datasource.primary
- 如果数据源bean名称以dataSource结尾，那前缀就是bean的名称去掉dataSource的部分（例如，batchDataSource的前缀是datasource.batch）
- 其他情况使用bean的名称作为前缀

通过注册一个自定义版本的DataSourcePublicMetrics bean，你可以覆盖部分或全部的默认行为。默认情况下，Spring Boot提供支持所有数据源的元数据；如果你喜欢的数据源恰好不被支持，你可以添加另外的DataSourcePoolMetadataProvider beans。具体参考DataSourcePoolMetadataProvidersConfiguration。
